<?php
if (!defined('ABSPATH')) {
  exit; // Exit if accessed directly.
}

class Ultimate_AI_Template_Controller
{
  private $Template_Manager;

  public function __construct()
  {
    $this->Template_Manager = new Ultimate_AI_Template_Manager();
    add_action('wp_ajax_ultimate_ai_create_template', array($this, 'ultimate_ai_create_template'));
    add_action('wp_ajax_ultimate_ai_get_templates', array($this, 'ultimate_ai_get_templates'));
    add_action('wp_ajax_ultimate_ai_update_template_meta', array($this, 'ultimate_ai_update_template_meta'));
    add_action('wp_ajax_ultimate_ai_delete_template', array($this, 'ultimate_ai_delete_template'));
    add_action('wp_ajax_ultimate_ai_save_blog_templates', array($this, 'save_blog_templates'));
    add_action('wp_ajax_ultimate_ai_get_blog_templates', array($this, 'get_blog_templates'));
  }

  function get_blog_templates()
  {
    //restrict only for admin
    $this->restrict_req_for_admin();
    wp_send_json(["data" => $this->Template_Manager->get_blog_templates()], 200);
  }

  public function save_blog_templates()
  {
    //restrict only for admin
    $this->restrict_req_for_admin();
    $this->must_fields_error(["payload"]);

    $payload = $_POST["payload"];
    //full_blog|title|outlines|regen|image 
    $prompts = ["full_blog", "title", "outlines", "regen", "image"];


    if (!is_array($payload)) {
      wp_send_json(["data" => "Invalid payload"], 400);
    }

    foreach ($prompts as $prompt) {
      if (!isset($prompt) || empty($prompt)) {
        wp_send_json(["data" => "Missing payload fields. Need: full_blog|title|outlines|regen|image"], 400);
      }
    }

    $this->Template_Manager->save_blog_template($payload);

    wp_send_json(["data" => $payload], 200);
  }

  public function ultimate_ai_create_template()
  {
    //restrict only for admin
    $this->restrict_req_for_admin();
    $this->must_fields_error(["name", "input_fields", "prompt"]);

    $name = $_POST["name"];
    $desc = $_POST["desc"];
    $key = sanitize_text_field($_POST["key"]);
    $icon_url = sanitize_text_field($_POST["icon_url"]);
    $is_featured = sanitize_text_field($_POST["is_featured"]) == "true" ? true : false;
    $input_fields = $_POST["input_fields"];
    $prompt = $_POST["prompt"];
    $id = (int)sanitize_text_field($_POST["id"]) ?? "0";

    if (!is_array($input_fields)) {
      wp_send_json(["data" => esc_html__("Invalid fields", ULTIMATE_AI_SLUG)], 400);
    }

    foreach ($input_fields as $field) {
      if (!$this->Template_Manager->ultimate_ai_validate_field($field)) {
        wp_send_json(["data" => esc_html__("Invalid fields", ULTIMATE_AI_SLUG)], 400);
      }
    }

    $res = $this->Template_Manager->ultimate_ai_create_template($name, $input_fields, $prompt, $desc, $key, $icon_url, $is_featured, $id);

    if (!$res["is_success"]) {
      wp_send_json(["data" => $res["message"]], 400);
    }


    wp_send_json(["data" => $res["data"]], 200);
  }

  public function ultimate_ai_update_template_meta()
  {
    //restrict only for admin
    $this->restrict_req_for_admin();
    $this->must_fields_error(["key_name", "value", "template_id"]);

    $key_name = sanitize_key($_POST["key_name"]);
    $value = $_POST["value"];
    $template_id = (int)sanitize_text_field($_POST["template_id"]);
    $is_direct_meta = true; // hard coded for now

    $exist = $this->Template_Manager->ultimate_ai_template_name_exist_by("p", $template_id);
    if (!$exist) {
      wp_send_json(["data" => esc_html__("Cant find template with id" . $template_id, ULTIMATE_AI_SLUG)], 400);
    }
    $res = $this->Template_Manager->ultimate_ai_update_template_meta($key_name, $value, $template_id, $is_direct_meta);

    if (!$res["is_success"]) {
      wp_send_json(["data" => $res["message"]], 400);
    }

    wp_send_json(["data" => $res["data"]], 200);
  }

  public function ultimate_ai_delete_template()
  {
    //restrict only for admin
    $this->restrict_req_for_admin();
    $this->must_fields_error(["template_id"]);
    $template_id = (int)sanitize_text_field($_POST["template_id"]);
    $exist = $this->Template_Manager->ultimate_ai_template_name_exist_by("p", $template_id);
    if (!$exist) {
      wp_send_json(["data" => esc_html__("Cant find template with id:" . $template_id, ULTIMATE_AI_SLUG)], 400);
    }
    $res = $this->Template_Manager->ultimate_ai_delete_template($template_id);
    if (!$res["is_success"]) {
      wp_send_json(["data" => $res["message"]], 400);
    }
    wp_send_json(["data" => $res["data"]], 200);
  }

  public function ultimate_ai_get_templates()
  {
    $s = sanitize_text_field($_POST["search"]) ?? "";
    $filter = ["s" => $s];
    $templates = $this->Template_Manager->ultimate_ai_get_templates($filter);
    wp_send_json(["data" => $templates], 200);
  }

  private function restrict_req_for_admin()
  {
    if (!current_user_can("edit_pages")) {
      wp_send_json("Not authorized", 401);
    }
  }

  private function must_fields_error($must_fields)
  {
    foreach ($must_fields as $field) {
      if (!$_POST[$field] || empty($_POST[$field])) {
        wp_send_json(array("data" => esc_html__("Send proper informations.", ULTIMATE_AI_SLUG)), 400);
      }
    }
  }
}
new Ultimate_AI_Template_Controller();
